package music;

public class Musician {
	
	private String name;
	private String instrument;
	
	public Musician(String name, String instrument) {
		super();
		this.name = name;
		this.instrument = instrument;
	}
	
	public Musician() {
		super();
	}
	
	public void prettyPrint() {
		System.out.println("Musician: ");
		System.out.println('\t' + this.name);
		System.out.println('\t' + this.instrument);
	}
	
	@Override
	public String toString() {
		return "Musician: " + this.name + ", " + this.instrument;
	}
	
	@Override
	public boolean equals(Object obj) {
	    if (obj instanceof Musician) {
	        Musician m = (Musician) obj;
	        if ((m.getName().equals(this.name)) && (m.getInstrument().equals(this.instrument))) {
	            return true;
	        }
	    }
	    return false;
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getInstrument() {
		return instrument;
	}
	public void setInstrument(String instrument) {
		this.instrument = instrument;
	}
	
	

}
